@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="card border-0 shadow-custom">
				<div class="card-header border-grey">
					<h3 class="card-title">
						{{ __('expense.update_title') }}
					</h3>
				</div>
				<form method="post" id="js-expense-form" action="{{ route('expense.update', $expense->id) }}">
					{{ csrf_field() }}
					<input name="_method" type="hidden" value="PATCH">
					<div class="card-body">
						<div class="row">
							<div class="col-lg-6">
								<div class="form-group">
									<label for="name" class="required">{{ __('expense.name') }}</label>
									<input type="text" value="{{ $expense->name }}"
										class="form-control @error('name') is-invalid @enderror" name="name" id="name">
									@error('name')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="amount" class="required">{{ __('expense.amount') }}</label>
									<input type="number" value="{{ $expense->transaction->amount }}"
										class="form-control @error('amount') is-invalid @enderror" name="amount"
										id="amount" placeholder="0">
									@error('amount')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-12">
								<div class="form-group">
									<label for="payment-date" class="required">{{ __('expense.payment_date') }}</label>
									<div class="input-group date" id="payment-date" data-target-input="nearest">
										<input type="text" value="{{ $expense->transaction->date }}"
											class="form-control @error('date') is-invalid @enderror" name="date"
											data-target="#payment-date" />
										<div class="input-group-append" data-target="#payment-date"
											data-toggle="datetimepicker">
											<div class="input-group-text"><i class="fa fa-calendar"></i></div>
										</div>
									</div>
									@error('date')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-12">
								<div class="form-group">
									<label for="description">{{ __('expense.description') }}</label>
									<textarea rows="4" class="form-control" name="description"
										id="description">{{ $expense->transaction->note }}</textarea>
								</div>
							</div>
							<div class="col-lg-12">
								<button type="submit" class="btn btn-primary mt-1">{{ __('expense.update_expense')
									}}</button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection
@section('js-script')
<!-- PAGE SPECIFIC CUSTOM SCRIPT -->
<script>
	$(function () {
		"use strict";
		// INITIALIZE THE DATE PICKER
		$('#payment-date').datetimepicker({
			format: 'YYYY-MM-DD'
		});
	});
</script>
@endsection